<?php
/****  script css読み込み  ****/
function load_script_css(){
	wp_enqueue_script( "main_script", get_template_directory_uri()."/script.js", array("jquery"), false, true );
	wp_enqueue_style( "style", get_stylesheet_uri(), false );
}
add_action('wp_enqueue_scripts', 'load_script_css');

function gutenberg_theme_support_setup() {
 
    // Default block styles Gutenberg
    add_theme_support( 'wp-block-styles' );
 
    // Wide Alignment Gutenberg
    //add_theme_support( 'align-wide' );
}
add_action( 'after_setup_theme', 'gutenberg_theme_support_setup' );

function principle_block_editor_styles() {
    wp_enqueue_style( '', get_theme_file_uri( '/gutenberg-editor-style.css' ), false, '1.0', 'all' );
}
add_action( 'enqueue_block_editor_assets', 'principle_block_editor_styles' );

/****  titleタグ  ****/
add_theme_support( 'title-tag' );

//サムネイル
add_theme_support('post-thumbnails');

/****  MENU有効化  ****/
register_nav_menus( array(
	"main_menu" => "メインメニュー（親子メニュー禁止）",
	"pickup_post" => "ピックアップ記事（3〜6記事）"
));

/****  ページ情報取得  ****/
function get_the_page_title(){
	if(is_home()){
		return get_bloginfo('name');
	}else if(is_archive()){
		return single_cat_title("", false)." | ".get_bloginfo('name');
	}else{
		return get_the_title()." | ".get_bloginfo('name');
	}
}
function get_the_page_description(){
	$description = "";
	if(is_home()){
		$description = get_bloginfo("description");
	}else if(is_archive()){
		$description = category_description();
	}else{
		global $post;
		$description = $post -> post_excerpt;
		if($description == ""){
			$description = mb_substr(trim(str_replace("\r\n", '', strip_tags($post-> post_content))), 0, 100);
		}
	}
	if($description == ""){
		$description = get_bloginfo('description');
	}
	return $description;
}
/****  category_description()の<p>を削除  ****/
remove_filter('term_description', 'wpautop');

function get_the_page_image(){
	$path = "";
	if(is_singular()){
		if(has_post_thumbnail()){
			$thumb_data = wp_get_attachment_image_src(get_post_thumbnail_id(), "full");
			if($thumb_data){
				$path = $thumb_data[0];
			}
		}
	}
	if(!$path){
		$path = get_site_image();
	}
	return $path;
}
function get_site_image(){
	$path = "";
	if(get_option("logo_id")){
		$path = get_option("logo_id");
	}
	if(!$path){
		if(get_header_image()){
			$path = get_header_image();
		}
	}
	if(!$path){
		$path = get_site_icon();
	}
	if(!$path){
		$path = get_stylesheet_directory_uri()."/images/no_image.png";
	}
	return $path;
}
function get_site_icon(){
	$path = "";
	$site_icon_id = get_option( 'site_icon' );
	if($site_icon_id){
		$icon_data = wp_get_attachment_image_src($site_icon_id, "full" );
		if($icon_data){
			$path = $icon_data[0];
		}
	}
	return $path;
}

function get_the_archive_page_title(){
	$title = "";
	if( is_category() ) {
		$title = '<i class="fas fa-folder"></i> '.single_cat_title("", false);
	} elseif( is_tag() ) {
		$title = '<i class="fas fa-tag"></i> '.single_tag_title("", false);
	} elseif( is_tax() ) {
		$title = '<i class="fas fa-folder"></i> '.single_term_title("", false);
	} elseif (is_day()) {
		$title = get_the_time('Y年m月d日')."に書かれた記事";
	} elseif (is_month()) {
		$title = get_the_time('Y年m月')."に書かれた記事";
	} elseif (is_year()) {
		$title = get_the_time('Y年')."に書かれた記事";
	} elseif (is_author()) {
		$title = esc_html(get_queried_object()->display_name)."が書いた記事";
	}
	return $title;
}


/**** ウィジェット ****/
register_sidebar(array(
	'id' => 'top_content',
	'name' => '記事直上',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="margin_30">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'under_content',
	'name' => '記事直下',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="margin_30">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'sidebar_top',
	'name' => 'サイドバー最上部（枠なし）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="no_box">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'sidebar',
	'name' => 'サイドバー（枠あり）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="box">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'sidebar_bottom',
	'name' => 'サイドバー最下部（枠なし）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="no_box">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'top_index',
	'name' => 'Index上部（枠なし）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="margin_30">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'under_index',
	'name' => 'Index下部（枠あり）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="box">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'under_index_no_box',
	'name' => 'Index下部（枠なし）',
	'before_title' => '<h2 class="box_header">',
	'after_title' => '</h2>',
	'before_widget' => '<div class="margin_30">',
	'after_widget' => '</div>'
));
register_sidebar(array(
	'id' => 'footer',
	'name' => 'フッターエリア（6個まで）',
	'before_title' => '<h2 class="footer_header"><i class="fas fa-caret-down"></i> ',
	'after_title' => '</h2>',
	'before_widget' => '<div class="footer_box">',
	'after_widget' => '</div>'
));

function get_widget_count($name){
	if(!$name) return;
	ob_start();
	dynamic_sidebar($name);
	$widgets = ob_get_clean();
	return mb_substr_count($widgets, "footer_box");
}

/**** 受信したコメント ****/
function mydesign($comment, $args, $depth){
$GLOBALS['comment'] = $comment; 
?>
<li class="compost" id="comment-<?php comment_ID() ?>">
	<div class="combody">
		<?php comment_text(); ?>
	</div><!-- .combody -->
	<p class="cominfo">
		by <?php comment_author_link(); ?>　<?php comment_date(); ?> <?php comment_time(); ?>
	</p>
</li>
<?php
}

/****  ページナビ  ****/
function pagination($pages = '', $range = 2){  
    $showitems = ($range * 2)+1;
    global $paged;
    if(empty($paged)) $paged = 1;
    	if($pages == ''){
        	global $wp_query;
        	$pages = $wp_query->max_num_pages;
        	if(!$pages){
            	$pages = 1;
        	}
    	}
		if(1 != $pages){
			echo "<div class='pagination'>";
			if($paged > 2 && $paged > $range+1 && $showitems < $pages){
				echo "<a href='".get_pagenum_link(1)."'>1</a>";
			}
		for ($i=1; $i <= $pages; $i++){
			if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
		    	echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
			}
		}
		if ($paged < $pages-2 &&  $paged+$range-2 < $pages && $showitems < $pages){
			echo "<a href='".get_pagenum_link($pages)."'>".$pages."</a>";
		}
		echo "</div>";
	}
}

/****  カスタムヘッダー  ****/
$defaults = array(
	'flex-height' => true, //フレキシブル対応（高さ）
	'flex-width'  => true, //フレキシブル対応（幅）
	'header-text' => false
);
add_theme_support( 'custom-header', $defaults );

/****  フィードリンク  ****/
add_theme_support( 'automatic-feed-links' );

/****  アドセンス表示設定  ****/
add_action('admin_menu', 'add_custom_box');
function add_custom_box(){
	add_meta_box( 'ad_view_setting_in_post','アドセンス表示設定', 'view_custom_box', 'post', 'side' );
	add_meta_box( 'ad_view_setting_in_page','アドセンス表示設定', 'view_custom_box', 'page', 'side' );
	add_meta_box( 'noindex_setting_in_post','No Index設定', 'view_custom_box_noindex', 'post', 'side' );
	add_meta_box( 'noindex_setting_in_page','No Index設定', 'view_custom_box_noindex', 'page', 'side' );
}
function view_custom_box(){
	global $post;
	$is_checked = get_post_meta(get_the_ID(),'is_no_adsense',true);
	echo '<label><input type="checkbox" name="is_no_adsense"';
	if($is_checked){echo " checked";}
	echo '>アドセンスを非表示にする</label>';
}
add_action('save_post', 'save_custom_data');
function save_custom_data(){
	$is_no_adsense;
	if(!empty($_POST["is_no_adsense"])){
		$is_no_adsense = $_POST["is_no_adsense"];
	}
	$id = get_the_ID();
	$meta_key = "is_no_adsense";
	add_post_meta($id, $meta_key, $is_no_adsense, true);
	update_post_meta($id, $meta_key, $is_no_adsense);
}

/****  No index設定  ****/
function view_custom_box_noindex(){
	global $post;
	$is_checked = get_post_meta(get_the_ID(),'is_no_index',true);
	echo '<label><input type="checkbox" name="is_no_index"';
	if($is_checked){echo " checked";}
	echo '>No indexにする（このページを検索エンジンに載せないように要求する）</label>';
}
add_action('save_post', 'save_custom_data_noindex');
function save_custom_data_noindex(){
	$is_no_index;
	if(!empty($_POST["is_no_index"])){
		$is_no_index = $_POST["is_no_index"];
	}
	$id = get_the_ID();
	$meta_key = "is_no_index";
	add_post_meta($id, $meta_key, $is_no_index, true);
	update_post_meta($id, $meta_key, $is_no_index);
}

/****  記事中にアドセンス表示  ****/
function add_ads_before_1st_h2($the_content) {
	$is_no_adsense = get_post_meta(get_the_ID(),'is_no_adsense',true);
	if (is_singular() && !$is_no_adsense) {
		$h2 = "/<h2.*?>/i";
		if (preg_match($h2, $the_content, $h2s)) {
			if(get_option("ad_h2")){
				$ad_responsive = "<div class='ad_box'><p class='sponsor'>スポンサーリンク</p>".get_option("ad_h2")."</div>";
				$the_content = preg_replace($h2, $ad_responsive.$h2s[0], $the_content, 2);
			}
		}
	}
	return $the_content;
}
add_filter('the_content','add_ads_before_1st_h2');

/**** テーマカスタマイザー設定 ****/
define("MAIN_COLOR_DEFAULT", "#5982f2");
define("ACCENT_COLOR_DEFAULT", "#1c294d");
define("HOVER_COLOR_DEFAULT", "#F2CA5A");

add_action( 'customize_register', 'my_customize_register' );
function my_customize_register($wp_customize) {

/*テキストエリア入力欄*/
if(class_exists('WP_Customize_Control')){
	class WP_Customize_Textarea_Control extends WP_Customize_Control {
		public $type = 'textarea';
		public function render_content() { ?>
<label>
<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
<textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
</label>

<?php		}
	}
}

/*ラジオボタン*/
function sanitize_choices( $input, $setting ) {
	global $wp_customize;
	$control = $wp_customize->get_control( $setting->id );
	if ( array_key_exists( $input, $control->choices ) ) {
		return $input;
	} else {
		return $setting->default;
	}
}

/*サイト基本情報*/
	/* 開始年（footer表示用） */
	$wp_customize->add_setting(
		'start_year',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'start_year',
		array(
			'section' => 'title_tagline',
			'settings' => 'start_year',
			'label' => 'サイト開始年（フッター表示用）',
			'type' => 'text'
		)
	);
	
	/* 色 */
	/*メインカラー*/
	$wp_customize->add_setting(
		'main_color',
		array(
			'default' => MAIN_COLOR_DEFAULT
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'main_color',
			array(
				'section' => 'colors',
				'settings' => 'main_color',
				'label' =>'メインカラー'
			)
		)
	);
	
	/*アクセントカラー*/
	$wp_customize->add_setting(
		'accent_color',
		array(
			'default' => ACCENT_COLOR_DEFAULT
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'accent_color',
			array(
				'section' => 'colors',
				'settings' => 'accent_color',
				'label' =>'アクセントカラー',
				'description' => '白は禁止'
			)
		)
	);
	/*hoverカラー*/
	$wp_customize->add_setting(
		'hover_color',
		array(
			'default' => HOVER_COLOR_DEFAULT
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'hover_color',
			array(
				'section' => 'colors',
				'settings' => 'hover_color',
				'label' =>'hoverカラー'
			)
		)
	);
	
	
/*ヘッダースタイル設定*/
$wp_customize->add_section(
	'header_setting',
	array(
		'title' => 'ヘッダースタイル設定',
		'priority' => 120
	)
);
	/* キャッチフレーズ表示 */
	$wp_customize->add_setting(
		'is_desc',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_desc',
		array(
			'section' => 'header_setting',
			'settings' => 'is_desc',
			'label' => 'ブログタイトル下にキャッチフレーズを表示する',
			'type' => 'checkbox'
		)
	);
	/* タイトルセンター表示 */
	$wp_customize->add_setting(
		'is_title_aligncenter',
		array(
			'default' => false
		)
	);
	$wp_customize->add_control(
		'is_title_aligncenter',
		array(
			'section' => 'header_setting',
			'settings' => 'is_title_aligncenter',
			'label' => 'ブログタイトルをセンター表示にする',
			'type' => 'checkbox'
		)
	);
	/* メニューセンター表示 */
	$wp_customize->add_setting(
		'is_menu_aligncenter',
		array(
			'default' => false
		)
	);
	$wp_customize->add_control(
		'is_menu_aligncenter',
		array(
			'section' => 'header_setting',
			'settings' => 'is_menu_aligncenter',
			'label' => 'グローバルメニューをセンター表示にする',
			'type' => 'checkbox'
		)
	);

/*indexスタイル設定*/
$wp_customize->add_section(
	'index_setting',
	array(
		'title' => 'Indexページ表示設定',
		'priority' => 130
	)
);
	/*サムネイル非表示*/
	$wp_customize->add_setting(
		'no_thumbnail',
		array(
			'default' => ''
		)
	);
	$wp_customize->add_control(
		'no_thumbnail',
		array(
			'section' => 'index_setting',
			'settings' => 'no_thumbnail',
			'label' => 'indexページのサムネイルを非表示にする',
			'type' => 'checkbox'
		)
	);
	
	/*サムネイルの高さ設定*/
	$wp_customize->add_setting(
		"thumbnail_height",
		array(
			"default" => ""
		)
	);
	$wp_customize->add_control(
		"thumbnail_height",
		array(
			"section" => "index_setting",
			"settings" => "thumbnail_height",
			"label" => "サムネイル画像の高さを統一",
			'type' => 'radio',
			'choices' => array(
				  0 => 'しない',
				 40 => '40px',
				 60 => '60px',
				 80 => '80px',
				100 => '100px',
				120 => '120px',
				140 => '140px',
				160 => '160px',
				180 => '180px',
				200 => '200px',
			)
		)
	);
	
/*記事ページの設定*/
$wp_customize->add_section(
	'content_page_setting',
	array(
		'title' => '記事ページ表示設定',
		'priority' => 140
	)
);
	/*更新日*/
	$wp_customize->add_setting(
		'is_show_rewrite_date',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_show_rewrite_date',
		array(
			'section' => 'content_page_setting',
			'settings' => 'is_show_rewrite_date',
			'label' => '記事の更新日を表示する',
			'type' => 'checkbox'
		)
	);
	/*記事上部のアイキャッチ*/
	$wp_customize->add_setting(
		'is_eyecatch',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_eyecatch',
		array(
			'section' => 'content_page_setting',
			'settings' => 'is_eyecatch',
			'label' => '記事タイトル下にアイキャッチ画像を表示する',
			'type' => 'checkbox'
		)
	);
	/*記事タイトル下にシェアボタン設置*/
	$wp_customize->add_setting(
		'is_share_top_of_content',
		array('default' => 'checked')
	);
	$wp_customize->add_control(
		'is_share_top_of_content',
		array(
			'section' => 'content_page_setting',
			'settings' => 'is_share_top_of_content',
			'label' => '記事上部にもシェアボタンを設置する',
			'type' => 'checkbox'
		)
	);
	/*関連記事の記事数*/
	$wp_customize->add_setting(
		'count_kanren',
		array(
			'default' => '4'
		)
	);
	$wp_customize->add_control(
		'count_kanren',
		array(
			'section' => 'content_page_setting',
			'settings' => 'count_kanren',
			'label' => '関連記事の表示数',
			'type' => 'select',
			'choices' => array(
				0 => '表示しない',
				4 => '4件',
				8 => '8件',
			)
		)
	);
	/*Index下部ウィジェットを記事ページにも*/
	$wp_customize->add_setting(
		'under_index_on_under_content',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'under_index_on_under_content',
		array(
			'section' => 'content_page_setting',
			'settings' => 'under_index_on_under_content',
			'label' => 'Index下部ウィジェットを記事下にも表示する',
			'type' => 'checkbox'
		)
	);

/*プロフィール欄*/
$wp_customize->add_section(
	'profile_setting',
	array(
		'title' => 'プロフィール欄設定',
		'priority' => 150
	)
);
	/*サイドバーにプロフィール設置？*/
	$wp_customize->add_setting(
		'is_prof_sidebar',
		array(
			'default' => false
		)
	);
	$wp_customize->add_control(
		'is_prof_sidebar',
		array(
			'section' => 'profile_setting',
			'settings' => 'is_prof_sidebar',
			'label' => 'サイドバーにプロフィールを設置する',
			'type' => 'checkbox'
		)
	);

	/*名前*/
	$wp_customize->add_setting(
		'prof_name',
		array(
			'type' => 'option',
		)
	);
	$wp_customize->add_control(
		'prof_name',
		array(
			'section' => 'profile_setting',
			'settings' => 'prof_name',
			'label' => '名前',
			'type' => 'text'
		)
	);

	/*自画像*/
	$wp_customize->add_setting(
		'prof_image',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control( new WP_Customize_Image_Control(
		$wp_customize,
		'prof_image',
		array(
			'section'   => 'profile_setting',
			'settings'  => 'prof_image',
			'label'     => 'アイコン'
		)
	));

	/*自己紹介*/
	$wp_customize->add_setting(
		'prof_text',
		array(
			'type' => 'option',
		)
	);
	if(class_exists('WP_Customize_Textarea_Control')){
		$wp_customize->add_control(new WP_Customize_Textarea_Control(
			$wp_customize,
			'prof_text',
			array(
				'section' => 'profile_setting',
				'settings' => 'prof_text',
				'label' => '簡単な自己紹介文'
			)
		));
	}

	/*リンク*/
	$wp_customize->add_setting(
		'prof_post_url',
		array(
			'type' => 'option',
		)
	);
	$wp_customize->add_control(
		'prof_post_url',
		array(
			'section' => 'profile_setting',
			'settings' => 'prof_post_url',
			'label' => 'プロフィールページのURL',
			'type' => 'text',
			'description' => 'プロフィールページがあれば、その記事ページのURLを入力してください'
		)
	);

	/*Twitterアカウント*/
	$wp_customize->add_setting(
		'twitter_account',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'twitter_account',
		array(
			'section' => 'profile_setting',
			'settings' => 'twitter_account',
			'label' => 'Twitterアカウント',
			'description' => "@不要",
			'type' => 'text'
		)
	);
	
	/*Instaアカウント*/
	$wp_customize->add_setting(
		'insta_account',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'insta_account',
		array(
			'section' => 'profile_setting',
			'settings' => 'insta_account',
			'label' => 'Instagramアカウント（ユーザーネーム）',
			'type' => 'text'
		)
	);

	/*Facebookページ*/
	$wp_customize->add_setting(
		'fb_account',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'fb_account',
		array(
			'section' => 'profile_setting',
			'settings' => 'fb_account',
			'label' => 'FacebookページのURL',
			'type' => 'text'
		)
	);
	
	/*メールアドレス*/
	$wp_customize->add_setting(
		'mail_address',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'mail_address',
		array(
			'section' => 'profile_setting',
			'settings' => 'mail_address',
			'label' => 'メールアドレス',
			'type' => 'text'
		)
	);

/*シェアボタンの設定*/
$wp_customize->add_section(
	'share_button_setting',
	array(
		'title' => 'シェアボタン設定',
		'priority' => 154
	)
);
	/*ツイートにメンションを含める*/
	$wp_customize->add_setting(
		'has_mention',
		array(
			'default' => 'false'
		)
	);
	$wp_customize->add_control(
		'has_mention',
		array(
			'section' => 'share_button_setting',
			'settings' => 'has_mention',
			'label' => 'ツイートにメンションを含める',
			'type' => 'checkbox'
		)
	);
	
/*AdSense設定*/
$wp_customize->add_section(
	'ad_setting', array(
		'title' => 'アドセンス設定',
		'priority' => 155
	)
);

	/*indexページ最上部の広告*/
	$wp_customize->add_setting(
			'ad_top_of_index',
			array(
				'default' => 'checked'
			)
	);
	$wp_customize->add_control(
		'ad_top_of_index',
		array(
			'section' => 'ad_setting',
			'settings' => 'ad_top_of_index',
			'label' => 'indexページの最上部に広告を表示する',
			'type' => 'checkbox'
		)
	);

	/*Indexページ用*/
	$wp_customize->add_setting(
		'ad_index',
		array(
			'type' => 'option',
		)
	);
	if(class_exists('WP_Customize_Textarea_Control')){
		$wp_customize->add_control(new WP_Customize_Textarea_Control(
			$wp_customize,
			'ad_index',
			array(
				'section' => 'ad_setting',
				'settings' => 'ad_index',
				'label' => 'Indexページ用'
			)
		));
	}
	/*記事内見出し上用*/
	$wp_customize->add_setting(
		'ad_h2',
		array(
			'type' => 'option',
		)
	);
	if(class_exists('WP_Customize_Textarea_Control')){
		$wp_customize->add_control(new WP_Customize_Textarea_Control(
			$wp_customize,
			'ad_h2',
			array(
				'section' => 'ad_setting',
				'settings' => 'ad_h2',
				'label' => '記事内の見出し上'
			)
		));
	}
	/*記事内見出し上用*/
	$wp_customize->add_setting(
		'ad_under_content',
		array(
			'type' => 'option',
		)
	);
	if(class_exists('WP_Customize_Textarea_Control')){
		$wp_customize->add_control(new WP_Customize_Textarea_Control(
			$wp_customize,
			'ad_under_content',
			array(
				'section' => 'ad_setting',
				'settings' => 'ad_under_content',
				'label' => '記事直下'
			)
		));
	}
	
/*analytics*/
$wp_customize->add_section(
	'analy_setting', array(
		'title' => 'アナリィティクス設定',
		'priority' => 160
	)
);

	/*アナリィティクスのコード*/
	$wp_customize->add_setting(
			'analy_code',
			array(
				'type' => 'option',
			)
	);
	if(class_exists('WP_Customize_Textarea_Control')){
		$wp_customize->add_control(new WP_Customize_Textarea_Control(
			$wp_customize,
			'analy_code',
			array(
				'section' => 'analy_setting',
				'settings' => 'analy_code',
				'label' => 'アナリィティクスのコード'
			)
		));
	}

	/*ログイン時除外*/
	$wp_customize->add_setting(
		'reject_logged_in',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control(
		'reject_logged_in',
		array(
			'section' => 'analy_setting',
			'settings' => 'reject_logged_in',
			'label' => 'ログイン中のアクセスをカウントしない',
			'type' => 'checkbox'
		)
	);
	

/*ロゴ・ファビコン・apple登録*/
$wp_customize->add_section(
	'image_setting', array(
		'title' => 'サイトロゴ設定',
		'priority' => 170
	)
);
	/*ロゴ登録*/
	$wp_customize->add_setting(
		'logo_id',
		array(
			'type' => 'option'
		)
	);
	$wp_customize->add_control( new WP_Customize_Image_Control(
		$wp_customize,
		'logo_id',
		array(
			'section'   => 'image_setting',
			'settings'  => 'logo_id',
			'label'     => 'ロゴ画像',
			'description' => 'サイトには表示されませんがSNSで拡散される際にアイキャッチとして使用されます'
		)
	));
	
/*UI設定*/
$wp_customize->add_section(
	'ui_setting', array(
		'title' => 'UI設定',
		'priority' => 175
	)
);
	/*サイドバーの検索*/
	$wp_customize->add_setting(
		'is_menu_fixed',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_menu_fixed',
		array(
			'section' => 'ui_setting',
			'settings' => 'is_menu_fixed',
			'label' => 'ナビゲーションメニューバーを固定表示する',
			'type' => 'checkbox'
		)
	);
	/*サイドバーの検索*/
	$wp_customize->add_setting(
		'is_set_search_box',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_set_search_box',
		array(
			'section' => 'ui_setting',
			'settings' => 'is_set_search_box',
			'label' => 'サイドバーに検索Boxを表示する',
			'type' => 'checkbox'
		)
	);
	/*Topへ戻るボタン*/
	$wp_customize->add_setting(
		'is_set_to_top',
		array(
			'default' => 'checked'
		)
	);
	$wp_customize->add_control(
		'is_set_to_top',
		array(
			'section' => 'ui_setting',
			'settings' => 'is_set_to_top',
			'label' => 'Topへ戻る（スクロール）ボタンを表示する',
			'type' => 'checkbox'
		)
	);
	/*Homeへ戻るボタン*/
	$wp_customize->add_setting(
			'is_set_to_home',
			array(
				'default' => 'checked'
			)
	);
	$wp_customize->add_control(
			'is_set_to_home',
			array(
				'section' => 'ui_setting',
				'settings' => 'is_set_to_home',
				'label' => 'Homeへ戻る（リンク）ボタンを表示する',
				'type' => 'checkbox'
			)
	);

//かんたんSSl化設定
$wp_customize->add_section(
	'ssl_setting',
	array(
		'title' => 'かんたんSSL化設定',
		'description' => 'サイトがhttpsで表示されるのを確認してから行って下さい。',
		'priority' => 180
	)
);
	/*imgをhttp→https*/
	$wp_customize->add_setting(
		'inner_http',
		array(
			'default' => ''
		)
	);
	$wp_customize->add_control(
		'inner_http',
		array(
			'section' => 'ssl_setting',
			'settings' => 'inner_http',
			'label' => '記事内の内部リンク及び画像ファイルURLをhttpからhttpsに一括変換する',
			'description' => '<a href="https://wp-principle.net/ssl/">かんたんSSL化機能の詳細</a>',
			'type' => 'checkbox'
		)
	);
}




/****  get_theme_mod関数  ****/
function is_desc(){
	return get_theme_mod("is_desc", true);
}
function is_menu_aligncenter(){
	return get_theme_mod("is_menu_aligncenter", false);
}
function is_title_aligncenter(){
	return get_theme_mod("is_title_aligncenter", false);
}
function get_main_color(){
	return get_theme_mod("main_color", MAIN_COLOR_DEFAULT);
}
function get_light_color_from($color){
	$rgb = str_split(ltrim($color, '#'), 2);
	$r = 15 * hexdec($rgb[0]) / 255;
	$g = 15 * hexdec($rgb[1]) / 255;
	$b = 15 * hexdec($rgb[2]) / 255;
	if($r < 10) $r = 10;
	if($g < 10) $g = 10;
	if($b < 10) $b = 10;
	return "#F".dechex($r)."F".dechex($g)."F".dechex($b);
}
function get_textcolor_on($color){
	$textcolor = "#555555";
	$rgb = str_split(ltrim($color, '#'), 2);
	$r = hexdec($rgb[0]);
	$g = hexdec($rgb[1]);
	$b = hexdec($rgb[2]);
	$dark_count = 0;
	if($r < 210) $dark_count++;
	if($g < 210) $dark_count++;
	if($b < 210) $dark_count++;
	if($dark_count >= 1) $textcolor = "#FFFFFF";
	return $textcolor;
}
function get_accent_color(){
	return get_theme_mod("accent_color", ACCENT_COLOR_DEFAULT);
}
function get_hover_color(){
	return get_theme_mod("hover_color", HOVER_COLOR_DEFAULT);
}
function get_thumbnail_height(){
	return get_theme_mod("thumbnail_height", "");
}
function is_share_top_of_content(){
	return get_theme_mod("is_share_top_of_content", true);
}
function get_count_kanren(){
	return get_theme_mod("count_kanren", 4);
}
function is_prof_sidebar(){
	return get_theme_mod("is_prof_sidebar", false);
}
function is_under_index_on_under_content(){
	return get_theme_mod("under_index_on_under_content", true);
}
function is_menu_fixed(){
	return get_theme_mod("is_menu_fixed", true);
}
function is_set_search_box(){
	return get_theme_mod("is_set_search_box", true);
}
function is_set_to_top(){
	return get_theme_mod("is_set_to_top", true);
}
function is_set_to_home(){
	return get_theme_mod("is_set_to_home", true);
}
function is_show_rewrite_date(){
	return get_theme_mod("is_show_rewrite_date", true);
}
function is_eyecatch(){
	return get_theme_mod("is_eyecatch", true);
}
function is_ad_top_of_index(){
	return get_theme_mod("ad_top_of_index", true);
}
function is_not_display_thumbnail(){
	return get_theme_mod("no_thumbnail", false);
}
function is_ssl_inner_http(){
	return get_theme_mod("inner_http", false);
}
function has_mention(){
	return get_theme_mod("has_mention", false);
}

//SSL設定
function http_to_https($the_content){
    $domain = $_SERVER["HTTP_HOST"];
 
    $src_http_single = "src=\'http://".$domain;
    $src_http_double = "src=\"http://".$domain;
    $src_https_single = "src=\'https://".$domain;
    $src_https_double = "src=\"https://".$domain;
 
    $href_http_single = "href=\'http://".$domain;
    $href_http_double = "href=\"http://".$domain;
    $href_https_single = "href=\'https://".$domain;
    $href_https_double = "href=\"https://".$domain;
 
    $http = array($src_http_single, $src_http_double, $href_http_single, $href_http_double);
    $https = array($src_https_single, $src_https_double, $href_https_single, $href_https_double);
    $the_content = str_replace($http, $https, $the_content);
     
    return $the_content;
}
if(is_ssl_inner_http()){
	add_filter('the_content', 'http_to_https');
}