<!DOCTYPE html>
<html lang="ja">
	<head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# blog: http://ogp.me/ns/blog#">
	<meta charset="UTF-8">
	<meta name="viewport" content="width= device-width">	
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>">
	<?php if(get_site_icon()){ ?>
		<link rel="shortcut icon" href="<?php echo get_site_icon() ?>" >
		<link rel="apple-touch-icon" href="<?php echo get_site_icon() ?>">
	<?php } ?>
	
	<!-- awesome -->
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
	
	<!-- ページのdescriptionを取得 -->
	<?php $description = get_the_page_description(); ?>
	<meta name="description" content="<?php echo $description ?>">
	<meta property="og:title" content="<?php echo get_the_page_title() ?>" >
	<meta property="og:type" content="blog" />
	<meta property="og:description" content="<?php echo $description ?>">
	<meta property="og:url" content="<?php echo home_url().$_SERVER["REQUEST_URI"]; ?>" >
	<meta property="og:image" content="<?php echo get_the_page_image() ?>" >
	<meta property="og:site_name" content="<?php bloginfo('name'); ?>" >
	<meta name="twitter:card" content="summary_large_image">
	<?php if(get_option("twitter_account")){ ?>
	    <meta name="twitter:site" content="@<?php echo get_option("twitter_account") ?>">
	<?php } ?>

	<!-- 404、検索、タグページ、月別アーカイブページ、noindex指定の個別ページはnoindex -->
	<?php if(is_404() || is_search() || is_tag() || is_date() || ( is_singular()&&get_post_meta(get_the_ID(),'is_no_index',true))){ ?>
		<meta name="robots" content="noindex">
	<?php } ?>

	<!-- ページ送りがある場合 -->
	<?php 
	global $paged, $max_page, $wp_query;
	if ( !$max_page ) $max_page = $wp_query->max_num_pages;
	if ( !$paged ) $paged = 1;
	$nextpage = intval($paged) + 1;
	if ( !is_singular() && ( $nextpage <= $max_page ) ) { ?>
		<link rel="next" href="<?php echo next_posts( $max_page, false ); ?>" />
	<?php }
	if ( !is_singular() && $paged > 1  ){ ?>
		<link rel="prev" href="<?php echo previous_posts( false ); ?>" />
	<?php } ?>
	
	<?php if (is_singular()) wp_enqueue_script( "comment-reply" ); ?>
	
	<?php wp_head(); ?>
	
	<style>
	body{background: <?php echo get_light_color_from(get_main_color()) ?>}
	nav{background: <?php echo get_main_color() ?>}
	nav li a, .menu_dots{color: <?php echo get_textcolor_on(get_main_color()) ?>;}
	nav li a:hover, .menu_dots:hover{background: <?php echo get_hover_color() ?>; color: <?php echo get_textcolor_on(get_main_color()) ?>}
	.box_header{color: <?php echo get_accent_color() ?>; border-bottom: 1px solid <?php echo get_accent_color() ?>}
	.single_post .post_date{border-top: 1px solid <?php echo get_main_color() ?>}
	.footer, .ui_button{background: <?php echo get_main_color() ?>; color: <?php echo get_textcolor_on(get_main_color()) ?>}
	.ui_buttons a{color: <?php echo get_textcolor_on(get_main_color()) ?>}
	.content h2, .category_tags a, .search_submit, .bread_wrap{color: <?php echo get_textcolor_on(get_accent_color()) ?>; background: <?php echo get_accent_color() ?>}
	.content h3{border-bottom: 3px solid <?php echo get_accent_color() ?>}
	.content h4, .content h5, .content h6{border-left-color: <?php echo get_accent_color() ?>}
	.site_title a, index_header{color: <?php echo get_accent_color() ?>}
	.bread a{color: <?php echo get_textcolor_on(get_accent_color()) ?>}
	.footer a{color: <?php echo get_textcolor_on(get_main_color()) ?>}
	.prof_top{background: <?php echo get_accent_color() ?>}
	.pagination span, .pagination a{color: <?php echo get_accent_color() ?>; border-color: <?php echo get_accent_color() ?>}
	.pagination .current, .pagination a:hover{color: <?php echo get_textcolor_on(get_accent_color()) ?>; background: <?php echo get_accent_color() ?>}
	.ui_button:hover{background: <?php echo get_hover_color() ?>; color: <?php echo get_textcolor_on(get_main_color()) ?>}
	.category_tags a:hover, .tags a:hover, .search_submit:hover, .comment_open:hover, .com-back a:hover, .com-next a:hover{background: <?php echo get_hover_color() ?>; color: <?php echo get_textcolor_on(get_accent_color()) ?>}
	a:hover, .post h3 a:hover, .sidebar li a:hover{color: <?php echo get_hover_color() ?>}
	<?php if(get_thumbnail_height()>0){ ?>
		.thumb_box{height: <?php echo get_thumbnail_height() ?>px}
		<?php if(get_thumbnail_height() < 80){ ?>
			.pickup_thumb_box{height: <?php echo get_thumbnail_height() ?>px}
		<?php } ?>
	<?php } ?>
	<?php if(is_title_aligncenter()){ ?>
		.site_title, .site_desc{text-align: center}
		.site_img_area img{margin-left: auto; margin-right: auto;}
	<?php } ?>
	<?php if(is_menu_aligncenter()){ ?>
		nav ul{text-align: center}
	<?php } ?>
	</style>
</head>

<body <?php body_class(); ?>>
	<!-- Analytics -->
	<?php if(get_option("analy_code")){
		if(get_option("reject_logged_in")){
			if(!is_user_logged_in()){
				echo get_option("analy_code");
			}
		}else{
			echo get_option("analy_code");
		} 
	} ?>
	<?php $site_title;
	if(get_header_image()){
		$site_title = "<img src='".get_header_image()."' alt='".get_bloginfo('name')."'>";
	}else{
		$site_title = get_bloginfo('name');
	} ?>
	<div class="header">
		<div class="header_inner">
			<?php if(is_home()){ ?>
				<?php if(get_header_image()){ ?>
					<h1 class="site_img_area"><a href="<?php echo home_url() ?>"><?php echo $site_title ?></a></h1>
				<?php }else{ ?>
					<h1 class="site_title"><a href="<?php echo home_url() ?>"><?php echo $site_title ?></a></h1>
				<?php } ?>
			<?php }else{ ?>
				<?php if(get_header_image()){ ?>
					<p class="site_img_area"><a href="<?php echo home_url() ?>"><?php echo $site_title ?></a></p>
				<?php }else{ ?>
			    	<p class="site_title"><a href="<?php echo home_url() ?>"><?php echo $site_title ?></a></p>
				<?php } ?>
			<?php } ?>
			<?php if(is_desc()){ ?>
				<p class="site_desc"><?php echo bloginfo("description") ?></p>
			<?php } ?>
		</div>
	</div><!-- .header -->
	
	<!-- ナビゲーションバー -->
	<nav class="nav">
		<div class="nav_inner">
			<i class="fas fa-ellipsis-v menu_dots"></i>
			<?php wp_nav_menu(array('theme_location' => 'main_menu')); ?>
		</div>
	</nav>

	<div class="main_side">
		<?php if(!is_singular()){ ?>
			<div class="top_pickup_wrap">
				<?php get_template_part("pickup"); ?>
			</div>
		<?php } ?>
		<div class="main">