<?php
$count = get_count_kanren();
if($count > 0 && is_single()){
	$tags = get_the_tags();
	$categories = get_the_category();
	$id = get_the_ID();
	$args;
	if($categories){
		$cat_array = array();
		$cats_string = "";
		foreach($categories as $category){
			array_push($cat_array, $category->slug);
			if($cats_string != "")$cats_string .= ",";
			$cats_string .= $category->slug;
		}
	}
	if($tags){
		$tag_array = array();
		foreach($tags as $tag){	
			array_push($tag_array, $tag->slug);
		}
		$args = array(
			'tax_query' => array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'category',
					'field' => 'slug',
					'terms' => $cat_array,
					'include_children' => true,
					'operator' => 'IN'
				),
				array(
					'taxonomy' => 'post_tag',
					'field' => 'slug',
					'terms' => $tag_array,
					'include_children' => false,
					'operator' => 'IN'
				)
			),
			'post__not_in' => array($id),
			'orderby'=>'rand',
			'posts_per_page' => $count
		);
	}else{
		$args = array(
			'category_name' => $cats_string,
			'post__not_in' => array($id),
			'orderby'=>'rand',
			'posts_per_page' => $count
		);
	}
	$the_query = new WP_Query($args); 
	if($the_query->have_posts()){ ?>
        <h2 class="box_header">関連記事</h2>
        <div class="quarter_posts">
            <?php $post_count = 0 ?>
            <?php set_query_var( 'quarter', true ) ?>
            <?php set_query_var( 'h3', true ) ?>
            <?php while($the_query->have_posts()){$the_query->the_post(); $post_count++; ?>
                <?php get_template_part("post_in_loop") ?>
            <?php } ?>
            <?php set_query_var( 'quarter', false ) ?>
            <?php set_query_var( 'h3', false ) ?>
        </div>
    <?php } ?>
    <?php if($post_count < 4){ ?>
        <style>
        	.quarter_posts{justify-content: flex-start} .quarter_post{margin-right: 1.3%}
        	@media screen and (max-width: 640px){.quarter_post{margin-right:0}}
        </style>
    <?php } ?>
    <?php wp_reset_query(); ?>
<?php } ?>