<?php get_header() ?>

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
	<div class="box single_post" itemprop="blogPost" itemscope itemtype="http://schema.org/BlogPosting">
		<?php $headline = $post -> post_excerpt;
		if(!$headline){
			$headline = mb_substr(strip_tags(get_the_content()), 0, 100);
		} ?>
		<meta itemprop="headline" content="<?php echo $headline ?>">
		<meta itemprop="mainEntityOfPage" content="<?php the_permalink() ?>">
		<?php $author_name = "" ?>
		<?php if(is_prof_sidebar() && get_option("prof_name")!=""){
			$author_name = get_option("prof_name");
		}else{
			$author = get_the_author();
			if($author){
				$author_name = $author;
			}else{
				$author_name = "不明";
			}
		} ?>
		<meta itemprop="author" content="<?php echo $author_name ?>">
		<span style="display:none" itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
			<meta itemprop="url" content="<?php echo get_the_page_image() ?>">
			
		</span>
		<span style="display:none" itemprop="publisher" itemscope itemtype='https://schema.org/Organization'>
			<meta itemprop="name" content="<?php echo bloginfo("name") ?>">
			<span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
				<meta itemprop="url" content="<?php echo get_site_image() ?>">
			</span>
		</span>
		<?php if(!is_single()){ ?><style>.post_date{display: none}</style><?php } ?>
		<?php if(!is_show_rewrite_date() || get_the_date() == get_the_modified_date()){ ?><style>.update_at{display: none}</style><?php } ?>
		<p class="post_date">
			<time itemprop="datePublished" datetime="<?php the_time("Y-m-d") ?>"><i class="fas fa-pen"></i> <?php the_time('Y/m/d') ?></time>　
			<time itemprop="dateModified" datetime="<?php the_modified_time("Y-m-d") ?>" class="update_at"><i class="fas fa-redo-alt"></i> <?php the_modified_time("Y/m/d"); ?></time>
		</p>
		
		<p class="category_tags"><?php the_category(' ') ?></p>
		<h1 class="" itemprop="name"><?php the_title(); ?></h1>
		<?php if(is_eyecatch()){ ?>
			<?php if(has_post_thumbnail()){ ?>
				<?php $title= get_the_title(); the_post_thumbnail("full", array('class'=>"post_thumbnail", 'alt' =>$title, 'title' => $title)); ?>
			<?php } ?>
		<?php } ?>
		<?php if(is_share_top_of_content()){ ?><?php get_template_part("share") ?><?php } ?>
		<div class="margin_30"></div>
		<?php dynamic_sidebar("top_content") ?>
		<div class="content" itemprop="articleBody">
			<?php the_content(); ?>
		</div>
		<?php dynamic_sidebar("under_content") ?>
		<?php get_template_part("ad_under_content") ?>
		<?php get_template_part("share") ?>
		<?php comments_template(); ?>
		<div class="tags">
			<?php $tags = get_the_tags("", " ") ?>
			<?php if($tags){ ?>
				<?php foreach($tags as $tag){ ?>
					<a href="/?tag=<?php echo $tag->slug ?>"><i class="fas fa-tag"></i> <?php echo $tag->name ?></a>
				<?php } ?>
			<?php } ?>
		</div>
	</div>
<?php endwhile; ?>
<?php endif; ?>

<?php if(is_single()){ ?>
	<?php get_template_part("prev_next") ?>
<?php } ?>

<?php get_template_part("kanren") ?>

<?php set_query_var("pickup_header", true) ?>
<?php get_template_part("pickup"); ?>
<?php set_query_var("pickup_header", false) ?>

<?php if(is_under_index_on_under_content()){ ?>
	<?php get_template_part("under_index") ?>
<?php } ?>

<?php get_sidebar(); ?>
<?php get_footer(); ?>