<?php $menu_name = 'pickup_post';
if (($locations = get_nav_menu_locations()) && isset($locations[ $menu_name ])){
    $menu_obj = wp_get_nav_menu_object( $locations[ $menu_name ] );
    if($menu_obj){
        $pickup_posts = wp_get_nav_menu_items($menu_obj->term_id);
        if($pickup_posts){ ?>
            <?php if(get_query_var("pickup_header")){ ?>
                <h2 class="box_header">Pick Up</h2>
            <?php } ?>
            <div class="pickup_posts_wrap">
                <div class="pickup_posts">
                    <?php $count = 0 ?>
                    <?php foreach($pickup_posts as $pickup_post){
                        if($pickup_post->object == "post"){ $count++ ?>
                            <div class="box pickup_post">
                                <a href="/?p=<?php echo $pickup_post->object_id ?>">
                                    <?php if(!is_not_display_thumbnail()){ ?>
                                        <div class="pickup_thumb_box">
                                            <?php if(has_post_thumbnail($pickup_post->object_id)){ ?>
                                                <?php echo get_the_post_thumbnail($pickup_post->object_id, array(300,300), array("class"=>"post_thumbnail", "alt"=>$pickup_post->title)) ?>
                                            <?php }else{ ?>
                                                <p class="no_thumbnail">No Thumbnail</p>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>
                                    <h2 class="pickup_title"><?php echo $pickup_post->title ?></h2>
                                </a>
                            </div>
                        <?php }
                    }
                    if($count > 0){
                        $width = round(100 / $count, 1) - 1;
                        $wrap = 180 * $count ?>
                        <style>
                            .pickup_post{width: <?php echo $width ?>%}
                            @media screen and (max-width: <?php echo $wrap ?>px){
                                .pickup_posts{width: <?php echo $wrap ?>px; padding: 0 2%;} 
                                .pickup_posts_wrap{overflow: scroll; width: 100vw; position: relative; left: 50%; transform: translateX(-50%);} 
                                .pickup_title{font-size: 0.8em;}
                            }
                        </style>
                    <?php } ?>
                </div>
            </div>
        <?php }
    }
}
?>